<?php
session_start();

function getVersionComposer()
{
    $jsonData = file_get_contents('composer.json');
    $dataArray = json_decode($jsonData, true);
    return $dataArray['version'];
}

function my_ini_get($name)
{
    $setting = (ini_get($name));
    $setting = ($setting == 1 || $setting == 'On') ? '<span class="circle-on"><span class="visually-hidden">On</span></span>' : '<span class="circle-off"><span class="visually-hidden">Off</span></span>';
    return $setting;
}

function my_func_get($name)
{
    $setting = (function_exists($name));
    $setting = ($setting == 1 || $setting == 'On') ? '<span class="circle-on"><span class="visually-hidden">On</span></span>' : '<span class="circle-off"><span class="visually-hidden">Off</span></span>';
    return $setting;
}

function my_ext_get($name)
{
    $setting = (extension_loaded($name));
    $setting = ($setting == 1 || $setting == 'On') ? '<span class="circle-on"><span class="visually-hidden">On</span></span>' : '<span class="circle-off"><span class="visually-hidden">Off</span></span>';
    return $setting;
}

function my_file_get($name)
{
    $setting = (file_exists($name));
    $setting = ($setting == 1 || $setting == 'On') ? '<span class="circle-on"><span class="visually-hidden">On</span></span>' : '<span class="circle-off"><span class="visually-hidden">Off</span></span>';
    return $setting;
}

function get_version_ioncube()
{
    if (function_exists('ioncube_loader_version')) {
        return ioncube_loader_version();
    } else {
        return '<span class="circle-off"><span class="visually-hidden">Off</span></span>';
    }
}

function check_htaccess()
{
    if (file_exists('.htaccess')) {
        if (strpos(file_get_contents('.htaccess'), 'RewriteRule . index.php [L]') !== false) {
            return '<span class="text-success">(valid)</span>';
        } else {
            return '<span class="text-danger">(invalid)</span>';
        }
    } else {
        return '<span class="text-danger">htaccess invalid</span>';
    }
}

?>
<!DOCTYPE html>
<html lang="en" data-bs-theme="dark">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="robots" content="noindex, nofollow">
    <title>System Requirements</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        .circle-off,
        .circle-on {
            height: 16px;
            width: 16px;
            display: inline-block;
            border-radius: 100%;
            border: 1.8px solid white;
        }

        .circle-off {
            background: red;
        }

        .circle-on {
            background: green;
        }
    </style>
</head>

<body>
    <div class="container-fluid mt-5">

        <div class="row d-flex justify-content-center">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header text-center">
                        <h1 class="h3">System Requirements</h1>
                    </div>
                    <div class="card-body">

                        <table class="table table-dark table-striped align-middle">

                            <thead class="sticky-top">
                                <tr>
                                    <th scope="col">#</th>
                                    <th scope="col">Recommended</th>
                                    <th scope="col">Current</th>
                                </tr>
                            </thead>

                            <tbody>
                                <tr>
                                    <th scope="row">PHP Version</th>
                                    <td>8.1 ~ 8.2</td>
                                    <td><?php echo phpversion(); ?></td>
                                </tr>

                                <tr>
                                    <th scope="row">File Uploads</th>
                                    <td><span class="circle-on"><span class="visually-hidden">On</span></span></td>
                                    <td><?php echo my_ini_get('file_uploads'); ?></td>
                                </tr>

                                <tr>
                                    <th scope="row">GD</th>
                                    <td><span class="circle-on"><span class="visually-hidden">On</span></span></td>
                                    <td><?php echo my_func_get('gd_info'); ?></td>
                                </tr>

                                <tr>
                                    <th scope="row">IonCube Loader</th>
                                    <td>13.0 or later</td>
                                    <td><?= get_version_ioncube(); ?></td>
                                </tr>

                                <tr>
                                    <th scope="row">Allow Url Fopen</th>
                                    <td><span class="circle-on"><span class="visually-hidden">On</span></span></td>
                                    <td><?php echo my_ini_get('allow_url_fopen'); ?></td>
                                </tr>

                                <tr>
                                    <th scope="row">cURL</th>
                                    <td><span class="circle-on"><span class="visually-hidden">On</span></span></td>
                                    <td><?php echo my_ext_get('curl'); ?></td>
                                </tr>

                                <tr>
                                    <th scope="row">JSON</th>
                                    <td><span class="circle-on"><span class="visually-hidden">On</span></span></td>
                                    <td><?php echo my_ext_get('json'); ?></td>
                                </tr>

                                <tr>
                                    <th scope="row">PDO SQLite</th>
                                    <td><span class="circle-on"><span class="visually-hidden">On</span></span></td>
                                    <td><?php echo my_ext_get('pdo_sqlite'); ?></td>
                                </tr>

                                <tr>
                                    <th scope="row">Zip</th>
                                    <td><span class="circle-on"><span class="visually-hidden">On</span></span></td>
                                    <td><?php echo my_ext_get('zip'); ?></td>
                                </tr>

                                <tr>
                                    <th scope="row">Exif</th>
                                    <td><span class="circle-on"><span class="visually-hidden">On</span></span></td>
                                    <td><?php echo my_ext_get('exif'); ?></td>
                                </tr>

                                <tr>
                                    <th scope="row">.htaccess <small><?= check_htaccess(); ?></small></th>
                                    <td><span class="circle-on"><span class="visually-hidden">On</span></span></td>
                                    <td><?php echo my_file_get('.htaccess'); ?> </td>
                                </tr>

                                <tr>
                                    <th scope="row">Session</th>
                                    <td><span class="circle-on"><span class="visually-hidden">On</span></span></td>
                                    <td><?php echo isset($_SESSION) ? '<span class="circle-on"><span class="visually-hidden">On</span></span>' : '<span class="circle-off"><span class="visually-hidden">Off</span></span>'; ?></td>
                                </tr>

                                <tr>
                                    <th scope="row">Upload Max Filesize</th>
                                    <td>32M or later</td>
                                    <td><?php echo ini_get("upload_max_filesize"); ?></td>
                                </tr>

                                <tr>
                                    <th scope="row">Post Max Size</th>
                                    <td>32M or later</td>
                                    <td><?php echo ini_get("post_max_size"); ?></td>
                                </tr>

                                <tr>
                                    <th scope="row">Memory Limit</th>
                                    <td>128M or later</td>
                                    <td><?php echo ini_get("memory_limit"); ?></td>
                                </tr>

                                <tr>
                                    <th scope="row">ImageMagick <small class="text-warning">(optional - upload GIF) </small></th>
                                    <td><span class="circle-on"><span class="visually-hidden">On</span></span></td>
                                    <td><?php echo my_ext_get('imagick'); ?></td>
                                </tr>

                            </tbody>
                        </table>

                    </div>
                </div>
                <p class="text-center mt-3">RádioBS - V<?php echo getVersionComposer(); ?></p>
            </div>
        </div>
    </div>
</body>

</html>
